///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK ManRestoreDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        ManRestoreDialog_hWnd = xHandle;

        SendMessage(ManRestoreDialog_hWnd, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)"Manual Restore");
        SendMessage(ManRestoreDialog_hWnd, WM_SETICON, TRUE, (LPARAM) LoadIcon(MainInstance, MAKEINTRESOURCE(100)) );

        MRD.Server_hWnd      = GetDlgItem(ManRestoreDialog_hWnd, 1000);
        MRD.DataBase_hWnd    = GetDlgItem(ManRestoreDialog_hWnd, 1001);
        MRD.Driver_hWnd      = GetDlgItem(ManRestoreDialog_hWnd, 1002);
        MRD.UserID_hWnd      = GetDlgItem(ManRestoreDialog_hWnd, 2000);
        MRD.UserPW_hWnd      = GetDlgItem(ManRestoreDialog_hWnd, 2001);
        MRD.RestoreFile_hWnd = GetDlgItem(ManRestoreDialog_hWnd, 3000);

        Set_Text(MRD.Server_hWnd,      RestoreServer);
//      Set_Text(MRD.DataBase_hWnd,    RestoreDataBase);
        Set_Text(MRD.Driver_hWnd,      RestoreDriver);
        Set_Text(MRD.UserID_hWnd,      RestoreUserID);
        Set_Text(MRD.UserPW_hWnd,      RestoreUserPW);
//      Set_Text(MRD.RestoreFile_hWnd, RestoreFile);

        RWMD.Complete = FALSE;

        if(RestoreTrusted)
            CheckDlgButton(ManRestoreDialog_hWnd, 2002, BST_CHECKED);

        CenterWindow(ManRestoreDialog_hWnd);

        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND) // Received A Message
    {
        if(wParam == 100) //- Okay (Dialog Command)
        {
            //--------------------------------------------------------
            char xDataBase[256];
            char xDriver[256];
            char xServer[256];
            char xUserID[256];
            char xUserPW[256];
            char xRestoreFile[256];

            ClearMem(xDataBase, 256);
            ClearMem(xDriver, 256);
            ClearMem(xServer, 256);
            ClearMem(xUserID, 256);
            ClearMem(xUserPW, 256);
            ClearMem(xRestoreFile, 256);

            Get_TextEx(MRD.DataBase_hWnd,   xDataBase,     256);
            Get_TextEx(MRD.Driver_hWnd,     xDriver,       256);
            Get_TextEx(MRD.Server_hWnd,     xServer,       256);
            Get_TextEx(MRD.UserID_hWnd,     xUserID,       256);
            Get_TextEx(MRD.UserPW_hWnd,     xUserPW,       256);
            Get_TextEx(MRD.RestoreFile_hWnd, xRestoreFile, 256);

            if( strlen(xDataBase) < 1)
            {
                MessageBox(ManRestoreDialog_hWnd, "You must specify a database name.", TitleCaption, 0);
                return 0;
            }
            if( strlen(xDriver) < 1)
            {
                MessageBox(ManRestoreDialog_hWnd, "You must specify a driver.", TitleCaption, 0);
                return 0;
            }
            if( strlen(xServer) < 1)
            {
                MessageBox(ManRestoreDialog_hWnd, "You must specify a server name.", TitleCaption, 0);
                return 0;
            }
            if( strlen(xRestoreFile) < 1)
            {
                MessageBox(ManRestoreDialog_hWnd, "You must specify a restore file name.", TitleCaption, 0);
                return 0;
            }

            if(!GetRestoreStatement(xRestoreFile))
            {
                return 0;
            }

            if(IsDlgButtonChecked(ManRestoreDialog_hWnd, 2002))
            {
                SQLProcess.IsTrusted = TRUE;
                RestoreTrusted = TRUE;
            }
            else{
                RestoreTrusted = FALSE;
                SQLProcess.IsTrusted = FALSE;
            }

            CopyString(xDataBase,   SQLProcess.DataBase, strlen(xDataBase));
            CopyString(xDriver,     SQLProcess.Driver,   strlen(xDriver));
            CopyString(xServer,     SQLProcess.Server,   strlen(xServer));
            CopyString(xUserID,     SQLProcess.UserID,   strlen(xUserID));
            CopyString(xUserPW,     SQLProcess.UserPW,   strlen(xUserPW));

            CopyString(xDataBase,    RestoreDataBase, strlen(xDataBase));
            CopyString(xDriver,      RestoreDriver,   strlen(xDriver));
            CopyString(xServer,      RestoreServer,   strlen(xServer));
            CopyString(xUserID,      RestoreUserID,   strlen(xUserID));
            CopyString(xUserPW,      RestoreUserPW,   strlen(xUserPW));
            CopyString(xRestoreFile, RestoreFile,     strlen(xRestoreFile));

            //--------------------------------------------------------

            SetValues();

            RunningManual = TRUE;

            RestoreJob(xRestoreFile);

            EndDialog(ManRestoreDialog_hWnd,0);
            DestroyWindow(ManRestoreDialog_hWnd);

            return 0;
        }

        if(wParam == 101) //- Cancel (Dialog Command)
        {
            EndDialog(ManRestoreDialog_hWnd,0);
            DestroyWindow(ManRestoreDialog_hWnd);
            return 0;
        }

		if(wParam==102) //- Browse (Dialog Command)
		{
            char FileName[256];
            char *DefaultExtension = NULL;
            char *Filters = "SQL-Backup-File\0*.sbf\0All-Files\0*.*\0\0";

            DWORD DialogType = OFD;
            DWORD Flags   = OFN_EXPLORER + OFN_LONGNAMES + OFN_PATHMUSTEXIST;

            Get_TextEx(MRD.RestoreFile_hWnd, FileName, 256);

            if(OSFileDialog(ManRestoreDialog_hWnd, FileName, DefaultExtension, TitleCaption, Filters, Get_CurrentDirectory(), OFD, Flags))
            {
                if(GetRestoreName(FileName))
                {
                    EnableWindow( GetDlgItem(ManRestoreDialog_hWnd, 100), TRUE); // Ok button          
                    EnableWindow( GetDlgItem(ManRestoreDialog_hWnd, 103), TRUE); // New DB Button
                    RWMD.Complete = FALSE;
                    Set_Text(MRD.RestoreFile_hWnd, FileName);
                }
            }

			return 0;
		}

		if(wParam==103) //- Select new database (Dialog Command)
		{
            DialogBox(MainInstance, MAKEINTRESOURCE(103), ManRestoreDialog_hWnd, RestoreWithMoveDialog);
//            JID.Dialog_hWnd = ManRestoreDialog_hWnd;
//            JID.Database_hWnd = MRD.DataBase_hWnd;
//        	DialogBox(MainInstance, MAKEINTRESOURCE(109), ManRestoreDialog_hWnd, SelectDBDialog);
            return 0;
        }

        return 0;   
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        EndDialog(ManRestoreDialog_hWnd,0);
        DestroyWindow(ManRestoreDialog_hWnd);
        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_DESTROY) // Received Destroy Message
    {
//        PostQuitMessage(0);
        return 0;
    }

    //--------------------------------------------------------------------------

    return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

